package parser;

/**
 * Grammar non-terminal -- P ::= ( E )
 */
public class P implements S {
    /**
     * Left parenthesis object.
     */
    private LeftPToken _leftP;

    /**
     * E object.
     */
    private E _e;

    /**
     * Right parenthesis object.
     */
    private RightPToken _rightP;

    /**
     * Constructor for the P grammar non-terminal.
     *
     * @param leftP  left parenthesis token
     * @param e      E object
     * @param rightP right parenthesis token
     */
    public P(LeftPToken leftP, E e, RightPToken rightP) {
        _leftP = leftP;
        _e = e;
        _rightP = rightP;
    }

    /**
     * Return a string representation.
     *
     * @return string representation
     */
    public String toString() {
        return _leftP.toString() + _e.toString() + _rightP.toString();
    }
}

